/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apiipc.generated.enums.CommandStatus;
import apiipc.generated.enums.DirectiveCommand;
import apiipc.ipc.IPCEvent;

public abstract class TerminalLineEvent
extends IPCEvent {
    public EventType type;

    public TerminalLineEvent(IPCEventLTV iPCEventLTV) {
        super(iPCEventLTV);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        TERMINAL_UPDATED,
        OUTPUT_WRITTEN,
        CURSOR_POSITION_CHANGED,
        DIRECTIVE_SENT,
        COMMAND_STARTED,
        COMMAND_ENDED,
        COMMAND_AUTO_COMPLETED,
        MODE_CHANGED,
        PROMPT_CHANGED,
        COMMAND_SELECTED_FROM_HISTORY;

    }

    public static class CommandSelectedFromHistory
    extends TerminalLineEvent {
        public String historyCommand;

        public CommandSelectedFromHistory(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.COMMAND_SELECTED_FROM_HISTORY;
            this.historyCommand = (String)iPCEventLTV.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\thistoryCommand = " + this.historyCommand;
        }
    }

    public static class PromptChanged
    extends TerminalLineEvent {
        public String newPrompt;

        public PromptChanged(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.PROMPT_CHANGED;
            this.newPrompt = (String)iPCEventLTV.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tnewPrompt = " + this.newPrompt;
        }
    }

    public static class ModeChanged
    extends TerminalLineEvent {
        public String newMode;
        public String newModeArg;
        public String newPrompt;

        public ModeChanged(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.MODE_CHANGED;
            this.newMode = (String)iPCEventLTV.getEventParameters().get(0);
            this.newModeArg = (String)iPCEventLTV.getEventParameters().get(1);
            this.newPrompt = (String)iPCEventLTV.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tnewMode = " + this.newMode + "\n\tnewModeArg = " + this.newModeArg + "\n\tnewPrompt = " + this.newPrompt;
        }
    }

    public static class CommandAutoCompleted
    extends TerminalLineEvent {
        public String inputCommand;
        public String completeCommand;

        public CommandAutoCompleted(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.COMMAND_AUTO_COMPLETED;
            this.inputCommand = (String)iPCEventLTV.getEventParameters().get(0);
            this.completeCommand = (String)iPCEventLTV.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tinputCommand = " + this.inputCommand + "\n\tcompleteCommand = " + this.completeCommand;
        }
    }

    public static class CommandEnded
    extends TerminalLineEvent {
        public String inputCommand;
        public CommandStatus status;

        public CommandEnded(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.COMMAND_ENDED;
            this.inputCommand = (String)iPCEventLTV.getEventParameters().get(0);
            this.status = CommandStatus.fromIntValue((Integer)iPCEventLTV.getEventParameters().get(1));
        }

        public String toString() {
            return super.toString() + "\n\tinputCommand = " + this.inputCommand + "\n\tstatus = " + (Object)((Object)this.status);
        }
    }

    public static class CommandStarted
    extends TerminalLineEvent {
        public String inputCommand;
        public String completeCommand;
        public String inputMode;

        public CommandStarted(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.COMMAND_STARTED;
            this.inputCommand = (String)iPCEventLTV.getEventParameters().get(0);
            this.completeCommand = (String)iPCEventLTV.getEventParameters().get(1);
            this.inputMode = (String)iPCEventLTV.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tinputCommand = " + this.inputCommand + "\n\tcompleteCommand = " + this.completeCommand + "\n\tinputMode = " + this.inputMode;
        }
    }

    public static class DirectiveSent
    extends TerminalLineEvent {
        public DirectiveCommand directiveCommand;
        public Integer cursorPositionFromEnd;

        public DirectiveSent(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.DIRECTIVE_SENT;
            this.directiveCommand = DirectiveCommand.fromIntValue((Integer)iPCEventLTV.getEventParameters().get(0));
            this.cursorPositionFromEnd = (Integer)iPCEventLTV.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tdirectiveCommand = " + (Object)((Object)this.directiveCommand) + "\n\tcursorPositionFromEnd = " + this.cursorPositionFromEnd;
        }
    }

    public static class CursorPositionChanged
    extends TerminalLineEvent {
        public Integer positionFromEnd;

        public CursorPositionChanged(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.CURSOR_POSITION_CHANGED;
            this.positionFromEnd = (Integer)iPCEventLTV.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tpositionFromEnd = " + this.positionFromEnd;
        }
    }

    public static class OutputWritten
    extends TerminalLineEvent {
        public String newOutput;
        public Boolean isDebug;
        public Integer cursorPositionFromEnd;

        public OutputWritten(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.OUTPUT_WRITTEN;
            this.newOutput = (String)iPCEventLTV.getEventParameters().get(0);
            this.isDebug = (Boolean)iPCEventLTV.getEventParameters().get(1);
            this.cursorPositionFromEnd = (Integer)iPCEventLTV.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tnewOutput = " + this.newOutput + "\n\tisDebug = " + this.isDebug + "\n\tcursorPositionFromEnd = " + this.cursorPositionFromEnd;
        }
    }

    public static class TerminalUpdated
    extends TerminalLineEvent {
        public String updatedStr;

        public TerminalUpdated(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.TERMINAL_UPDATED;
            this.updatedStr = (String)iPCEventLTV.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tupdatedStr = " + this.updatedStr;
        }
    }
}

